/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.continuous;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.cards.Card;
import mage.constants.CommanderCardType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.TargetController;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.game.stack.StackObject;
import mage.players.Player;
import mage.util.CardUtil;
import mage.watchers.common.SpellsCastWatcher;

public class NextSpellCastHasAbilityEffect
extends ContinuousEffectImpl {
    private int spellsCast;
    private final Ability ability;
    private final FilterCard filter;
    private final TargetController targetController;

    public NextSpellCastHasAbilityEffect(Ability ability) {
        this(ability, StaticFilters.FILTER_CARD);
    }

    public NextSpellCastHasAbilityEffect(Ability ability, FilterCard filter) {
        this(ability, filter, TargetController.SOURCE_CONTROLLER);
    }

    public NextSpellCastHasAbilityEffect(Ability ability, FilterCard filter, TargetController targetController) {
        super(Duration.EndOfTurn, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.ability = ability;
        this.filter = filter;
        this.targetController = targetController;
        this.staticText = "the next " + filter.getMessage().replace("card", "spell") + (targetController == TargetController.SOURCE_CONTROLLER ? " you cast" : " target player casts") + " this turn has " + CardUtil.getTextWithFirstCharLowerCase(CardUtil.stripReminderText(ability.getRule()));
    }

    private NextSpellCastHasAbilityEffect(NextSpellCastHasAbilityEffect effect) {
        super(effect);
        this.spellsCast = effect.spellsCast;
        this.ability = effect.ability;
        this.filter = effect.filter;
        this.targetController = effect.targetController;
    }

    @Override
    public NextSpellCastHasAbilityEffect copy() {
        return new NextSpellCastHasAbilityEffect(this);
    }

    @Override
    public void init(Ability source, Game game) {
        super.init(source, game);
        SpellsCastWatcher watcher = game.getState().getWatcher(SpellsCastWatcher.class);
        if (watcher != null) {
            this.spellsCast = watcher.getCount(source.getControllerId());
        }
    }

    @Override
    public boolean apply(Game game, Ability source) {
        UUID playerId;
        switch (this.targetController) {
            case SOURCE_TARGETS: {
                playerId = source.getFirstTarget();
                break;
            }
            case SOURCE_CONTROLLER: {
                playerId = source.getControllerId();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Value for targetController in NextSpellCastHasAbilityEffect not supported: " + (Object)((Object)this.targetController));
            }
        }
        Player player = game.getPlayer(playerId);
        SpellsCastWatcher watcher = game.getState().getWatcher(SpellsCastWatcher.class);
        if (player == null || watcher == null) {
            return false;
        }
        if (watcher.getSpellsCastThisTurn(playerId).stream().skip(this.spellsCast).anyMatch(s -> this.filter.match((Card)s, playerId, source, game))) {
            this.discard();
            return false;
        }
        for (Card card2 : game.getExile().getCardsInRange(game, playerId)) {
            if (!this.filter.match(card2, playerId, source, game)) continue;
            game.getState().addOtherAbility(card2, this.ability);
        }
        for (Card card2 : player.getLibrary().getCards(game)) {
            if (!this.filter.match(card2, playerId, source, game)) continue;
            game.getState().addOtherAbility(card2, this.ability);
        }
        for (Card card2 : player.getHand().getCards(game)) {
            if (!this.filter.match(card2, playerId, source, game)) continue;
            game.getState().addOtherAbility(card2, this.ability);
        }
        for (Card card2 : player.getGraveyard().getCards(game)) {
            if (!this.filter.match(card2, playerId, source, game)) continue;
            game.getState().addOtherAbility(card2, this.ability);
        }
        game.getCommanderCardsFromCommandZone(player, CommanderCardType.ANY).stream().filter(card -> this.filter.match((Card)card, playerId, source, game)).forEach(card -> game.getState().addOtherAbility((Card)card, this.ability));
        for (StackObject stackObject : game.getStack()) {
            Card card3;
            if (!(stackObject instanceof Spell) || !stackObject.isControlledBy(playerId) || (card3 = game.getCard(stackObject.getSourceId())) == null || !this.filter.match((Spell)stackObject, playerId, source, game)) continue;
            game.getState().addOtherAbility(card3, this.ability);
        }
        return true;
    }
}

