/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.continuous;

import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.TargetController;
import mage.game.Game;
import mage.players.Player;

public class PlayWithHandRevealedEffect
extends ContinuousEffectImpl {
    private TargetController who;

    public PlayWithHandRevealedEffect(TargetController who) {
        super(Duration.WhileOnBattlefield, Layer.PlayerEffects, SubLayer.NA, Outcome.Detriment);
        this.who = who;
    }

    protected PlayWithHandRevealedEffect(PlayWithHandRevealedEffect effect) {
        super(effect);
        this.who = effect.who;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Collection<UUID> affectedPlayers;
            switch (this.who) {
                case ANY: {
                    affectedPlayers = game.getState().getPlayersInRange(controller.getId(), game);
                    break;
                }
                case OPPONENT: {
                    affectedPlayers = game.getOpponents(source.getControllerId());
                    break;
                }
                case YOU: {
                    ArrayList<UUID> tmp = new ArrayList<UUID>();
                    tmp.add(source.getControllerId());
                    affectedPlayers = tmp;
                    break;
                }
                default: {
                    return false;
                }
            }
            for (UUID playerID : affectedPlayers) {
                Player player = game.getPlayer(playerID);
                if (player == null) continue;
                player.revealCards("Cards in " + player.getName() + "'s hand", player.getHand(), game, false);
            }
            return true;
        }
        return false;
    }

    @Override
    public PlayWithHandRevealedEffect copy() {
        return new PlayWithHandRevealedEffect(this);
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        switch (this.who) {
            case ANY: {
                return "Players play with their hands revealed";
            }
            case OPPONENT: {
                return "Your opponents play with their hands revealed";
            }
            case YOU: {
                return "Play with your hand revealed";
            }
        }
        return "Unknown TargetController for PlayWithHandRevealedEffect";
    }
}

