/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.continuous;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.Effect;
import mage.abilities.effects.RestrictionEffect;
import mage.abilities.effects.common.ChooseModeEffect;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.ModeChoice;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.players.PlayerList;

public class PlayerCanOnlyAttackInDirectionRestrictionEffect
extends RestrictionEffect {
    public PlayerCanOnlyAttackInDirectionRestrictionEffect(Duration duration, String directionText) {
        super(duration, Outcome.Neutral);
        this.staticText = (Object)((Object)duration) + (duration.toString().isEmpty() ? "" : ", ") + "each player may attack only the nearest opponent in " + directionText + " and planeswalkers controlled by that opponent";
    }

    private PlayerCanOnlyAttackInDirectionRestrictionEffect(PlayerCanOnlyAttackInDirectionRestrictionEffect effect) {
        super(effect);
    }

    @Override
    public PlayerCanOnlyAttackInDirectionRestrictionEffect copy() {
        return new PlayerCanOnlyAttackInDirectionRestrictionEffect(this);
    }

    public static Effect choiceEffect() {
        return new ChooseModeEffect(ModeChoice.LEFT, ModeChoice.RIGHT);
    }

    @Override
    public boolean applies(Permanent permanent, Ability source, Game game) {
        return true;
    }

    @Override
    public boolean canAttack(Permanent attacker, UUID defenderId, Ability source, Game game, boolean canUseChooseDialogs) {
        Permanent planeswalker;
        boolean left;
        if (defenderId == null) {
            return true;
        }
        if (ModeChoice.LEFT.checkMode(game, source)) {
            left = true;
        } else if (ModeChoice.RIGHT.checkMode(game, source)) {
            left = false;
        } else {
            return false;
        }
        Player playerAttacking = game.getPlayer(attacker.getControllerId());
        if (playerAttacking == null) {
            return true;
        }
        if (!game.getState().getPlayersInRange(source.getControllerId(), game).contains(playerAttacking.getId())) {
            return true;
        }
        Player playerDefending = game.getPlayer(defenderId);
        if (playerDefending == null && (planeswalker = game.getPermanent(defenderId)) != null && planeswalker.getCardType(game).contains((Object)CardType.PLANESWALKER)) {
            playerDefending = game.getPlayer(planeswalker.getControllerId());
        }
        if (playerDefending == null) {
            return false;
        }
        PlayerList playerList = game.getState().getPlayerList(playerAttacking.getId());
        return !(left && !((UUID)playerList.getNext()).equals(playerDefending.getId()) || !left && !((UUID)playerList.getPrevious()).equals(playerDefending.getId()));
    }
}

