/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.continuous;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.AttachmentType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;

public class SetCardColorAttachedEffect
extends ContinuousEffectImpl {
    private ObjectColor setColor;
    private AttachmentType attachmentType;

    public SetCardColorAttachedEffect(ObjectColor setColor, Duration duration, AttachmentType attachmentType) {
        super(duration, Layer.ColorChangingEffects_5, SubLayer.NA, Outcome.Benefit);
        this.setColor = setColor;
        this.attachmentType = attachmentType;
        this.setText();
    }

    protected SetCardColorAttachedEffect(SetCardColorAttachedEffect effect) {
        super(effect);
        this.setColor = effect.setColor;
        this.attachmentType = effect.attachmentType;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Permanent target;
        Permanent equipment = game.getPermanent(source.getSourceId());
        if (equipment != null && equipment.getAttachedTo() != null && (target = game.getPermanent(equipment.getAttachedTo())) != null) {
            target.getColor(game).setColor(this.setColor);
            return true;
        }
        return false;
    }

    @Override
    public SetCardColorAttachedEffect copy() {
        return new SetCardColorAttachedEffect(this);
    }

    private void setText() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.attachmentType.verb());
        sb.append(" creature is ").append(this.setColor.getDescription());
        this.staticText = sb.toString();
    }
}

