/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.cost;

import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.common.PlayLandAsCommanderAbility;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.cards.Card;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;

public class CommanderCostModification
extends CostModificationEffectImpl {
    private final Card commander;

    public CommanderCostModification(Card commander) {
        super(Duration.Custom, Outcome.Neutral, CostModificationType.INCREASE_COST);
        this.commander = commander;
    }

    protected CommanderCostModification(CommanderCostModification effect) {
        super(effect);
        this.commander = effect.commander;
    }

    @Override
    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        return this.commander.commanderCost(game, source, abilityToModify);
    }

    @Override
    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        Card cardToCheck = game.getCard(abilityToModify.getSourceId());
        if (cardToCheck == null) {
            return false;
        }
        return this.commander.getId().equals(cardToCheck.getMainCard().getId()) && (abilityToModify instanceof SpellAbility && abilityToModify.getZone() == Zone.COMMAND || abilityToModify instanceof PlayLandAsCommanderAbility);
    }

    @Override
    public CommanderCostModification copy() {
        return new CommanderCostModification(this);
    }
}

