/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.counter;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.OneShotEffect;
import mage.choices.ChoiceImpl;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.targetpointer.EachTargetPointer;
import mage.util.RandomUtil;

public class MoveCounterTargetsEffect
extends OneShotEffect {
    private final CounterType counterType;

    public MoveCounterTargetsEffect() {
        this((CounterType)null);
    }

    public MoveCounterTargetsEffect(CounterType counterType) {
        super(Outcome.Detriment);
        this.counterType = counterType;
        this.setTargetPointer(new EachTargetPointer());
    }

    protected MoveCounterTargetsEffect(MoveCounterTargetsEffect effect) {
        super(effect);
        this.counterType = effect.counterType;
    }

    @Override
    public MoveCounterTargetsEffect copy() {
        return new MoveCounterTargetsEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        CounterType typeToRemove;
        List permanents = this.getTargetPointer().getTargets(game, source).stream().map(game::getPermanent).filter(Objects::nonNull).collect(Collectors.toList());
        if (permanents.size() < 2) {
            return false;
        }
        Permanent fromPermanent = (Permanent)permanents.get(0);
        if (this.counterType != null && !fromPermanent.getCounters(game).containsKey(this.counterType)) {
            return false;
        }
        if (this.counterType == null) {
            HashSet<String> types = new HashSet<String>(fromPermanent.getCounters(game).keySet());
            switch (types.size()) {
                case 0: {
                    return false;
                }
                case 1: {
                    typeToRemove = CounterType.findByName((String)RandomUtil.randomFromCollection(types));
                    break;
                }
                default: {
                    Player player = game.getPlayer(source.getControllerId());
                    if (player == null) {
                        return false;
                    }
                    ChoiceImpl choice = new ChoiceImpl(true);
                    choice.setChoices(types);
                    choice.setMessage("Choose a type of counter to move");
                    player.choose(Outcome.BoostCreature, choice, game);
                    typeToRemove = CounterType.findByName(choice.getChoice());
                    break;
                }
            }
        } else {
            typeToRemove = this.counterType;
        }
        if (typeToRemove == null) {
            return false;
        }
        Permanent toPermanent = (Permanent)permanents.get(1);
        if (!toPermanent.addCounters(typeToRemove.createInstance(), source, game)) {
            return false;
        }
        fromPermanent.removeCounters(typeToRemove.createInstance(), source, game);
        return true;
    }

    @Override
    public String getText(Mode mode) {
        if (!this.staticText.isEmpty()) {
            return this.staticText;
        }
        StringBuilder sb = new StringBuilder("move ");
        sb.append(Optional.ofNullable(this.counterType).map(c -> this.counterType.getArticle() + ' ' + this.counterType.getName()).orElse("a"));
        sb.append(" counter from ");
        sb.append(((Target)mode.getTargets().get(0)).getDescription());
        sb.append(" onto ");
        sb.append(((Target)mode.getTargets().get(1)).getDescription());
        return sb.toString();
    }
}

