/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.counter;

import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

public class MoveCountersFromTargetToSourceEffect
extends OneShotEffect {
    private final CounterType counterType;
    private final int amount;

    public MoveCountersFromTargetToSourceEffect() {
        this(CounterType.P1P1);
    }

    public MoveCountersFromTargetToSourceEffect(CounterType counterType) {
        this(counterType, 1);
    }

    public MoveCountersFromTargetToSourceEffect(CounterType counterType, int amount) {
        super(Outcome.Neutral);
        this.counterType = counterType;
        this.amount = amount;
    }

    protected MoveCountersFromTargetToSourceEffect(MoveCountersFromTargetToSourceEffect effect) {
        super(effect);
        this.counterType = effect.counterType;
        this.amount = effect.amount;
    }

    @Override
    public MoveCountersFromTargetToSourceEffect copy() {
        return new MoveCountersFromTargetToSourceEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Permanent sourcePermanent = source.getSourcePermanentIfItStillExists(game);
        Permanent targetPermanent = game.getPermanent(source.getFirstTarget());
        if (sourcePermanent == null || targetPermanent == null || sourcePermanent.getId().equals(targetPermanent.getId()) || targetPermanent.getCounters(game).getCount(this.counterType) < this.amount || !sourcePermanent.addCounters(this.counterType.createInstance(this.amount), source.getControllerId(), source, game)) {
            return false;
        }
        targetPermanent.removeCounters(this.counterType.createInstance(this.amount), source, game);
        return true;
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        return "move " + CardUtil.numberToText(this.amount, "a") + ' ' + this.counterType.getName() + (this.amount > 1 ? " counters" : " counter") + " from " + this.getTargetPointer().describeTargets(mode.getTargets(), "that creature") + " onto {this}";
    }
}

