/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.counter;

import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;

public class RemoveAllCountersPermanentTargetEffect
extends OneShotEffect {
    private final CounterType counterType;

    public RemoveAllCountersPermanentTargetEffect() {
        this((CounterType)null);
    }

    public RemoveAllCountersPermanentTargetEffect(CounterType counterType) {
        super(Outcome.Neutral);
        this.counterType = counterType;
    }

    public RemoveAllCountersPermanentTargetEffect(RemoveAllCountersPermanentTargetEffect effect) {
        super(effect);
        this.counterType = effect.counterType;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent != null) {
            if (this.counterType == null) {
                permanent.removeAllCounters(source, game);
            } else {
                permanent.removeAllCounters(this.counterType.getName(), source, game);
            }
            return true;
        }
        return false;
    }

    @Override
    public RemoveAllCountersPermanentTargetEffect copy() {
        return new RemoveAllCountersPermanentTargetEffect(this);
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        return "remove all " + (this.counterType == null ? "" : this.counterType.getName() + " ") + "counters from " + this.getTargetPointer().describeTargets(mode.getTargets(), "it");
    }
}

