/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.discard;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.StaticValue;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

public class DiscardTargetEffect
extends OneShotEffect {
    protected DynamicValue amount;
    protected boolean randomDiscard;

    public DiscardTargetEffect(DynamicValue amount) {
        this(amount, false);
    }

    public DiscardTargetEffect(DynamicValue amount, boolean randomDiscard) {
        super(Outcome.Discard);
        this.randomDiscard = randomDiscard;
        this.amount = amount;
    }

    public DiscardTargetEffect(int amount) {
        this(StaticValue.get(amount));
    }

    public DiscardTargetEffect(int amount, boolean randomDiscard) {
        super(Outcome.Discard);
        this.randomDiscard = randomDiscard;
        this.amount = StaticValue.get(amount);
    }

    protected DiscardTargetEffect(DiscardTargetEffect effect) {
        super(effect);
        this.amount = effect.amount.copy();
        this.randomDiscard = effect.randomDiscard;
    }

    @Override
    public DiscardTargetEffect copy() {
        return new DiscardTargetEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        for (UUID targetPlayerId : this.getTargetPointer().getTargets(game, source)) {
            Player player = game.getPlayer(targetPlayerId);
            if (player == null) continue;
            player.discard(this.amount.calculate(game, source, this), this.randomDiscard, false, source, game);
        }
        return true;
    }

    @Override
    public String getText(Mode mode) {
        String message;
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        StringBuilder sb = new StringBuilder(this.getTargetPointer().describeTargets(mode.getTargets(), "that player"));
        sb.append(" discards ");
        String value = this.amount.toString();
        sb.append(CardUtil.numberToText(value, "a"));
        sb.append(value.equals("1") ? " card" : " cards");
        if (this.randomDiscard) {
            sb.append(" at random");
        }
        if (!(message = this.amount.getMessage()).isEmpty()) {
            sb.append(value.equals("X") ? ", where X is " : " for each ");
            sb.append(message);
        }
        return sb.toString();
    }
}

