/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.keyword;

import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.keyword.AirbendingCastEffect;
import mage.cards.Card;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;

public class AirbendTargetEffect
extends OneShotEffect {
    public AirbendTargetEffect() {
        super(Outcome.Benefit);
    }

    private AirbendTargetEffect(AirbendTargetEffect effect) {
        super(effect);
    }

    @Override
    public AirbendTargetEffect copy() {
        return new AirbendTargetEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Set permanents = this.getTargetPointer().getTargets(game, source).stream().map(game::getPermanent).filter(Objects::nonNull).collect(Collectors.toSet());
        if (player == null || permanents.isEmpty()) {
            return false;
        }
        player.moveCards(permanents, Zone.EXILED, source, game);
        CardsImpl cards = new CardsImpl(permanents);
        cards.retainZone(Zone.EXILED, game);
        for (Card card : cards.getCards(game)) {
            game.addEffect(new AirbendingCastEffect(card, game), source);
        }
        game.fireEvent(GameEvent.getEvent(GameEvent.EventType.AIRBENDED, source.getSourceId(), source, source.getControllerId()));
        return true;
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        return "airbend " + this.getTargetPointer().describeTargets(mode.getTargets(), "");
    }
}

