/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.keyword;

import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BecomesCreatureTargetEffect;
import mage.abilities.effects.keyword.EarthbendingDelayedTriggeredAbility;
import mage.abilities.keyword.HasteAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.custom.CreatureToken;
import mage.util.CardUtil;

public class EarthbendTargetEffect
extends OneShotEffect {
    private final int amount;

    public EarthbendTargetEffect(int amount) {
        super(Outcome.Benefit);
        this.amount = amount;
    }

    private EarthbendTargetEffect(EarthbendTargetEffect effect) {
        super(effect);
        this.amount = effect.amount;
    }

    @Override
    public EarthbendTargetEffect copy() {
        return new EarthbendTargetEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) {
            return false;
        }
        game.addEffect(new BecomesCreatureTargetEffect(new CreatureToken(0, 0).withAbility(HasteAbility.getInstance()), false, true, Duration.Custom), source);
        permanent.addCounters(CounterType.P1P1.createInstance(this.amount), source, game);
        game.addDelayedTriggeredAbility(new EarthbendingDelayedTriggeredAbility(permanent, game), source);
        game.fireEvent(GameEvent.getEvent(GameEvent.EventType.EARTHBENDED, permanent.getId(), source, source.getControllerId(), this.amount));
        return true;
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        return "earthbend " + this.amount + ". <i>(Target land you control becomes a 0/0 creature with haste that's still a land. Put " + CardUtil.numberToText(this.amount, "a") + " +1/+1 counter" + (this.amount > 1 ? "s" : "") + " on it. When it dies or is exiled, return it to the battlefield tapped.)</i>";
    }
}

