/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.keyword;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.keyword.ManifestEffect;
import mage.cards.Card;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.ManifestedDreadEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

public class ManifestDreadEffect
extends OneShotEffect {
    public ManifestDreadEffect() {
        super(Outcome.Benefit);
        this.staticText = "manifest dread";
    }

    private ManifestDreadEffect(ManifestDreadEffect effect) {
        super(effect);
    }

    @Override
    public ManifestDreadEffect copy() {
        return new ManifestDreadEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        return player != null && ManifestDreadEffect.doManifestDread(player, source, game) != null;
    }

    public static Permanent doManifestDread(Player player, Ability source, Game game) {
        Card card;
        CardsImpl cards = new CardsImpl(player.getLibrary().getTopCards(game, 2));
        switch (cards.size()) {
            case 0: {
                return null;
            }
            case 1: {
                card = cards.getRandom(game);
                break;
            }
            default: {
                TargetCardInLibrary target = new TargetCardInLibrary();
                target.withChooseHint("to manifest");
                player.choose(Outcome.PutCreatureInPlay, cards, target, source, game);
                card = cards.get(target.getFirstTarget(), game);
            }
        }
        Permanent permanent = card != null ? (Permanent)ManifestEffect.doManifestCards(game, source, player, new CardsImpl(card).getCards(game)).stream().findFirst().orElse(null) : null;
        cards.retainZone(Zone.LIBRARY, game);
        player.moveCards(cards, Zone.GRAVEYARD, source, game);
        cards.retainZone(Zone.GRAVEYARD, game);
        game.fireEvent(new ManifestedDreadEvent(permanent, source, player.getId(), cards, game));
        return permanent;
    }
}

