/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.keyword;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.costs.mana.ManaCosts;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.StaticValue;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BecomesFaceDownCreatureEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

public class ManifestEffect
extends OneShotEffect {
    private final DynamicValue amount;
    private final boolean isPlural;
    private final boolean cloakNotManifest;

    public ManifestEffect(int amount) {
        this(StaticValue.get(amount), amount > 1);
    }

    public ManifestEffect(DynamicValue amount) {
        this(amount, true);
    }

    private ManifestEffect(DynamicValue amount, boolean isPlural) {
        this(amount, isPlural, false);
    }

    public ManifestEffect(DynamicValue amount, boolean isPlural, boolean cloakNotManifest) {
        super(Outcome.PutCreatureInPlay);
        this.amount = amount;
        this.isPlural = isPlural;
        this.cloakNotManifest = cloakNotManifest;
        this.staticText = this.setText();
    }

    private ManifestEffect(ManifestEffect effect) {
        super(effect);
        this.amount = effect.amount;
        this.isPlural = effect.isPlural;
        this.cloakNotManifest = effect.cloakNotManifest;
    }

    @Override
    public ManifestEffect copy() {
        return new ManifestEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        int manifestAmount = this.amount.calculate(game, source, this);
        return !ManifestEffect.doManifestCards(game, source, controller, controller.getLibrary().getTopCards(game, manifestAmount), this.cloakNotManifest).isEmpty();
    }

    public static List<Permanent> doManifestCards(Game game, Ability source, Player manifestPlayer, Set<Card> cardsToManifest) {
        return ManifestEffect.doManifestCards(game, source, manifestPlayer, cardsToManifest, false);
    }

    public static List<Permanent> doManifestCards(Game game, Ability source, Player manifestPlayer, Set<Card> cardsToManifest, boolean cloakNotManifest) {
        return ManifestEffect.doManifestCards(game, source, manifestPlayer, cardsToManifest, cloakNotManifest, false);
    }

    public static List<Permanent> doManifestCards(Game game, Ability source, Player manifestPlayer, Set<Card> cardsToManifest, boolean cloakNotManifest, boolean tapped) {
        if (cardsToManifest.isEmpty()) {
            return Collections.emptyList();
        }
        Ability newSource = source.copy();
        newSource.setWorksFaceDown(true);
        for (Card card : cardsToManifest) {
            Card battlefieldCard = BecomesFaceDownCreatureEffect.findDefaultCardSideForFaceDown(game, card);
            ManaCosts<ManaCost> manaCosts = null;
            if (battlefieldCard.isCreature(game)) {
                ManaCosts<ManaCost> manaCosts2 = manaCosts = battlefieldCard.getSpellAbility() != null ? battlefieldCard.getSpellAbility().getManaCosts() : null;
                if (manaCosts == null) {
                    manaCosts = new ManaCostsImpl<ManaCost>("{0}");
                }
            }
            MageObjectReference objectReference = new MageObjectReference(battlefieldCard.getId(), battlefieldCard.getZoneChangeCounter(game) + 1, game);
            game.addEffect(new BecomesFaceDownCreatureEffect(manaCosts, objectReference, Duration.Custom, cloakNotManifest ? BecomesFaceDownCreatureEffect.FaceDownType.CLOAKED : BecomesFaceDownCreatureEffect.FaceDownType.MANIFESTED), newSource);
        }
        ArrayList<Permanent> manifested = new ArrayList<Permanent>();
        manifestPlayer.moveCards(cardsToManifest, Zone.BATTLEFIELD, source, game, tapped, true, false, null);
        for (Card card : cardsToManifest) {
            Card battlefieldCard = BecomesFaceDownCreatureEffect.findDefaultCardSideForFaceDown(game, card);
            Permanent permanent = game.getPermanent(battlefieldCard.getId());
            if (permanent == null) continue;
            if (cloakNotManifest) {
                permanent.setCloaked(true);
            } else {
                permanent.setManifested(true);
            }
            manifested.add(permanent);
        }
        return manifested;
    }

    private String setText() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.cloakNotManifest ? "cloak" : "manifest");
        sb.append(" the top ");
        if (this.isPlural) {
            sb.append(CardUtil.numberToText(this.amount.toString())).append(" cards ");
        } else {
            sb.append("card ");
        }
        sb.append("of your library. ");
        if (this.isPlural) {
            sb.append("<i>(To manifest a card, put it onto the battlefield face down as a 2/2 creature. You may turn it face up at any time for its mana cost if it's a creature card.)</i>");
        } else {
            sb.append("<i>(Put it onto the battlefield face down as a 2/2 creature. Turn it face up at any time for its mana cost if it's a creature card.)</i>");
        }
        return sb.toString();
    }
}

