/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.keyword;

import mage.MageObject;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.ProtectionAbility;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.FilterObject;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

public class ProtectionChosenColorAttachedEffect
extends ContinuousEffectImpl {
    protected ObjectColor chosenColor;
    protected ProtectionAbility protectionAbility;
    protected final boolean notRemoveItself;
    protected boolean notRemoveControlled;

    public ProtectionChosenColorAttachedEffect(boolean notRemoveItself) {
        super(Duration.WhileOnBattlefield, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.notRemoveItself = notRemoveItself;
        this.staticText = "enchanted creature has protection from the chosen color" + (notRemoveItself ? ". This effect doesn't remove {this}" : "");
    }

    protected ProtectionChosenColorAttachedEffect(ProtectionChosenColorAttachedEffect effect) {
        super(effect);
        if (effect.chosenColor != null) {
            this.chosenColor = effect.chosenColor.copy();
        }
        if (effect.protectionAbility != null) {
            this.protectionAbility = effect.protectionAbility.copy();
        }
        this.notRemoveItself = effect.notRemoveItself;
    }

    @Override
    public ProtectionChosenColorAttachedEffect copy() {
        return new ProtectionChosenColorAttachedEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Permanent attachement = game.getPermanent(source.getSourceId());
        if (attachement != null && attachement.getAttachedTo() != null) {
            ObjectColor color = (ObjectColor)game.getState().getValue(attachement.getId() + "_color");
            if (!(color == null || this.protectionAbility != null && color.equals(this.chosenColor))) {
                this.chosenColor = color;
                FilterObject<MageObject> protectionFilter = new FilterObject<MageObject>(this.chosenColor.getDescription());
                protectionFilter.add(new ColorPredicate(this.chosenColor));
                this.protectionAbility = new ProtectionAbility(protectionFilter);
                if (this.notRemoveItself) {
                    this.protectionAbility.setAuraIdNotToBeRemoved(source.getSourceId());
                }
                if (this.notRemoveControlled) {
                    this.protectionAbility.setDoesntRemoveControlled(true);
                    this.protectionAbility.setRemoveEquipment(false);
                    this.protectionAbility.setRemovesAuras(false);
                }
            }
            if (this.protectionAbility != null) {
                Permanent attachedTo = game.getPermanent(attachement.getAttachedTo());
                if (attachedTo != null) {
                    attachedTo.addAbility(this.protectionAbility, source.getSourceId(), game);
                }
                return true;
            }
        }
        return false;
    }

    public ProtectionChosenColorAttachedEffect setNotRemoveControlled(boolean notRemoveControlled) {
        this.notRemoveControlled = notRemoveControlled;
        return this;
    }
}

