/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.mana;

import mage.Mana;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.StaticValue;
import mage.abilities.effects.mana.ManaEffect;
import mage.abilities.mana.builder.ConditionalManaBuilder;
import mage.constants.ColoredManaSymbol;
import mage.game.Game;
import mage.util.CardUtil;

public class AddConditionalManaChosenColorEffect
extends ManaEffect {
    private ObjectColor chosenColorInfo = null;
    private final ConditionalManaBuilder manaBuilder;
    private final DynamicValue amount;

    public AddConditionalManaChosenColorEffect(int amount, ConditionalManaBuilder manaBuilder) {
        this(StaticValue.get(amount), manaBuilder);
    }

    public AddConditionalManaChosenColorEffect(DynamicValue amount, ConditionalManaBuilder manaBuilder) {
        this.amount = amount;
        this.manaBuilder = manaBuilder;
        String value = amount instanceof StaticValue ? CardUtil.numberToText(((StaticValue)amount).getValue()) : amount.toString();
        this.staticText = "Add " + value + " mana of the chosen color. " + manaBuilder.getRule();
    }

    private AddConditionalManaChosenColorEffect(AddConditionalManaChosenColorEffect effect) {
        super(effect);
        this.chosenColorInfo = effect.chosenColorInfo;
        this.manaBuilder = effect.manaBuilder;
        this.amount = effect.amount;
    }

    @Override
    public AddConditionalManaChosenColorEffect copy() {
        return new AddConditionalManaChosenColorEffect(this);
    }

    @Override
    public Mana produceMana(Game game, Ability source) {
        if (game != null) {
            ObjectColor color = (ObjectColor)game.getState().getValue(source.getSourceId() + "_color");
            int value = this.amount.calculate(game, source, this);
            if (color != null && value > 0) {
                this.chosenColorInfo = color;
                return (Mana)this.manaBuilder.setMana(new Mana(ColoredManaSymbol.lookup(color.toString().charAt(0)), value), source, game).build(new Object[0]);
            }
        }
        return new Mana();
    }
}

