/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.hint.common;

import mage.abilities.Ability;
import mage.abilities.hint.Hint;
import mage.abilities.hint.HintUtils;
import mage.game.Game;
import mage.players.Player;

public enum CanPlayAdditionalLandsHint implements Hint
{
    instance;


    @Override
    public String getText(Game game, Ability ability) {
        Player controller = game.getPlayer(ability.getControllerId());
        if (controller == null) {
            return "";
        }
        if (controller.getLandsPerTurn() == 1) {
            return "";
        }
        String stats = String.format(" (played %d of %s)", controller.getLandsPlayed(), controller.getLandsPerTurn() == Integer.MAX_VALUE ? "any" : String.valueOf(controller.getLandsPerTurn()));
        if (controller.canPlayLand()) {
            return HintUtils.prepareText("Can play more lands" + stats, null, "ICON_GOOD");
        }
        return HintUtils.prepareText("Can't play lands" + stats, null, "ICON_BAD");
    }

    @Override
    public Hint copy() {
        return instance;
    }
}

