/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.hint.common;

import java.util.Optional;
import mage.abilities.Ability;
import mage.abilities.condition.common.HaveInitiativeCondition;
import mage.abilities.hint.ConditionHint;
import mage.abilities.hint.Hint;
import mage.game.Game;

public enum InitiativeHint implements Hint
{
    instance;

    private static final ConditionHint hint;

    @Override
    public String getText(Game game, Ability ability) {
        String res = hint.getText(game, ability);
        if (game.getInitiativeId() == null) {
            return res + " (no Initiative in the game)";
        }
        return res + Optional.ofNullable(game.getPlayer(game.getInitiativeId())).map(p -> " (current owner: " + p.getName() + ")").orElse("");
    }

    @Override
    public Hint copy() {
        return instance;
    }

    static {
        hint = new ConditionHint(HaveInitiativeCondition.instance, "You have the Initiative");
    }
}

