/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.hint.common;

import java.util.List;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.hint.Hint;
import mage.game.Game;

public enum ModesAlreadyUsedHint implements Hint
{
    instance;


    @Override
    public String getText(Game game, Ability ability) {
        List used = ability.getModes().streamAlreadySelectedModes(ability, game).map(Mode::getModeTag).filter(tag -> tag != null && !tag.isEmpty()).collect(Collectors.toList());
        if (used.isEmpty()) {
            return "";
        }
        return "Already used" + (ability.getModes().isLimitUsageResetOnNewTurn() ? " this turn" : "") + ": [" + String.join((CharSequence)", ", used) + "]";
    }

    @Override
    public ModesAlreadyUsedHint copy() {
        return instance;
    }
}

