/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.icon.system;

import java.util.List;
import java.util.stream.Collectors;
import mage.abilities.icon.CardIconImpl;
import mage.abilities.icon.CardIconType;
import mage.players.PlayableObjectStats;

public final class PlayableCountIcon
extends CardIconImpl {
    public PlayableCountIcon(PlayableObjectStats objectStats) {
        super(CardIconType.PLAYABLE_COUNT, PlayableCountIcon.getHint(objectStats), PlayableCountIcon.getAmount(objectStats));
    }

    private static String getAmount(PlayableObjectStats objectStats) {
        return String.valueOf(objectStats.getPlayableAmount());
    }

    private static String getHint(PlayableObjectStats objectStats) {
        String res = "Playable abilities: " + objectStats.getPlayableAmount();
        List<String> list = objectStats.getPlayableAbilityNames();
        int[] counter = new int[]{0};
        if (!list.isEmpty()) {
            res = res + "<br>" + list.stream().map(s -> {
                counter[0] = counter[0] + 1;
                return " " + counter[0] + ". " + s;
            }).collect(Collectors.joining("<br>")) + "";
        }
        return res;
    }
}

