/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.StaticAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.Costs;
import mage.abilities.costs.OptionalAdditionalCost;
import mage.abilities.costs.OptionalAdditionalCostImpl;
import mage.abilities.costs.OptionalAdditionalSourceCosts;
import mage.abilities.costs.common.BeholdDragonCost;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

public class BeholdDragonAbility
extends StaticAbility
implements OptionalAdditionalSourceCosts {
    private static final String promptString = "Behold a Dragon";
    private static final String keywordText = "As an additional cost to cast this spell, you may behold a Dragon";
    private static final String reminderText = "Choose a Dragon you control or reveal a Dragon card from your hand.";
    private final String rule;
    public static final String BEHOLD_DRAGON_ACTIVATION_VALUE_KEY = "beholdDragonActivation";
    protected OptionalAdditionalCost additionalCost;

    public static OptionalAdditionalCost makeCost() {
        OptionalAdditionalCostImpl cost = new OptionalAdditionalCostImpl(keywordText, reminderText, new BeholdDragonCost());
        cost.setRepeatable(false);
        return cost;
    }

    public BeholdDragonAbility() {
        super(Zone.STACK, null);
        this.additionalCost = BeholdDragonAbility.makeCost();
        this.rule = this.additionalCost.getName() + ". " + this.additionalCost.getReminderText();
        this.setRuleAtTheTop(true);
    }

    private BeholdDragonAbility(BeholdDragonAbility ability) {
        super(ability);
        this.rule = ability.rule;
        this.additionalCost = ability.additionalCost.copy();
    }

    @Override
    public BeholdDragonAbility copy() {
        return new BeholdDragonAbility(this);
    }

    public void resetCost() {
        if (this.additionalCost != null) {
            this.additionalCost.reset();
        }
    }

    @Override
    public void addOptionalAdditionalCosts(Ability ability, Game game) {
        if (!(ability instanceof SpellAbility)) {
            return;
        }
        Player player = game.getPlayer(ability.getControllerId());
        if (player == null) {
            return;
        }
        this.resetCost();
        boolean canPay = this.additionalCost.canPay(ability, this, ability.getControllerId(), game);
        if (!canPay || !player.chooseUse(Outcome.Exile, "Behold a Dragon?", ability, game)) {
            return;
        }
        this.additionalCost.activate();
        for (Cost cost : (Costs)((Object)this.additionalCost)) {
            ability.getCosts().add(cost.copy());
        }
        ability.setCostsTag(BEHOLD_DRAGON_ACTIVATION_VALUE_KEY, null);
    }

    @Override
    public String getCastMessageSuffix() {
        return this.additionalCost.getCastSuffixMessage(0);
    }

    @Override
    public String getRule() {
        return this.rule;
    }
}

