/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import java.util.ArrayList;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.watchers.common.BloodthirstWatcher;

class BloodthirstEffect
extends OneShotEffect {
    private final int amount;

    BloodthirstEffect(int amount) {
        super(Outcome.BoostCreature);
        this.amount = amount;
        this.staticText = "this permanent comes into play with " + this.amount + " +1/+1 counters on it";
    }

    BloodthirstEffect(BloodthirstEffect effect) {
        super(effect);
        this.amount = effect.amount;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        BloodthirstWatcher watcher;
        Player player = game.getPlayer(source.getControllerId());
        if (player != null && (watcher = game.getState().getWatcher(BloodthirstWatcher.class, source.getControllerId())) != null && watcher.conditionMet()) {
            Permanent permanent = game.getPermanentEntering(source.getSourceId());
            if (permanent != null) {
                ArrayList appliedEffects = (ArrayList)this.getValue("appliedEffects");
                permanent.addCounters(CounterType.P1P1.createInstance(this.amount), source.getControllerId(), source, game, appliedEffects);
            }
            return true;
        }
        return false;
    }

    @Override
    public BloodthirstEffect copy() {
        return new BloodthirstEffect(this);
    }
}

