/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.keyword.CascadeEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;

public class CascadeAbility
extends TriggeredAbilityImpl {
    private static final String rule = "cascade";
    private static final String ruleReminder = "cascade <i>(When you cast this spell, exile cards from the top of your library until you exile a nonland card that costs less. You may cast it without paying its mana cost. Put the exiled cards on the bottom of your library in a random order.)</i>";
    private final boolean withReminder;

    public CascadeAbility() {
        this(true);
    }

    public CascadeAbility(boolean withReminder) {
        super(Zone.STACK, new CascadeEffect());
        this.withReminder = withReminder;
    }

    private CascadeAbility(CascadeAbility ability) {
        super(ability);
        this.withReminder = ability.withReminder;
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        Spell spell = game.getStack().getSpell(event.getTargetId());
        return spell != null && spell.getSourceId().equals(this.getSourceId());
    }

    @Override
    public String getRule() {
        return this.withReminder ? ruleReminder : rule;
    }

    @Override
    public CascadeAbility copy() {
        return new CascadeAbility(this);
    }
}

