/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import java.util.Collection;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.CardsImpl;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;
import mage.target.common.TargetCardInExile;
import mage.util.CardUtil;

class CascadeEffect
extends OneShotEffect {
    CascadeEffect() {
        super(Outcome.PutCardInPlay);
    }

    private CascadeEffect(CascadeEffect effect) {
        super(effect);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Card sourceCard = game.getCard(source.getSourceId());
        if (sourceCard == null) {
            return false;
        }
        CardsImpl cardsToExile = new CardsImpl();
        int sourceCost = sourceCard.getManaValue();
        Card cardToCast = null;
        for (Card card : controller.getLibrary().getCards(game)) {
            cardsToExile.add(card);
            controller.moveCards(card, Zone.EXILED, source, game);
            game.processAction();
            if (card.isLand(game) || card.getManaValue() >= sourceCost) continue;
            cardToCast = card;
            break;
        }
        controller.getLibrary().reset();
        GameEvent event = GameEvent.getEvent(GameEvent.EventType.CASCADE_LAND, source.getSourceId(), source, source.getControllerId(), 0);
        game.replaceEvent(event);
        if (event.getAmount() > 0) {
            TargetCardInExile target = new TargetCardInExile(0, event.getAmount(), (FilterCard)StaticFilters.FILTER_CARD_LAND);
            target.withChooseHint("land to put onto battlefield tapped");
            controller.choose(Outcome.PutCardInPlay, cardsToExile, target, source, game);
            controller.moveCards(new CardsImpl((Collection<UUID>)target.getTargets()).getCards(game), Zone.BATTLEFIELD, source, game, true, false, false, null);
        }
        FilterCard filter = new FilterCard();
        filter.add(new ManaValuePredicate(ComparisonType.FEWER_THAN, sourceCost + 1));
        CardUtil.castSpellWithAttributesForFree(controller, source, game, new CardsImpl(cardToCast), filter);
        cardsToExile.retainZone(Zone.EXILED, game);
        return controller.putCardsOnBottomOfLibrary(cardsToExile, game, source, false);
    }

    @Override
    public CascadeEffect copy() {
        return new CascadeEffect(this);
    }
}

