/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import java.util.UUID;
import mage.abilities.ActivatedAbility;
import mage.abilities.ActivatedAbilityImpl;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.keyword.SetClassLevelEffect;
import mage.constants.TimingRule;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;

public class ClassLevelAbility
extends ActivatedAbilityImpl {
    private final int level;
    private final String manaString;

    public ClassLevelAbility(int level, String manaString) {
        super(Zone.BATTLEFIELD, new SetClassLevelEffect(level), new ManaCostsImpl(manaString));
        this.level = level;
        this.manaString = manaString;
        this.setTiming(TimingRule.SORCERY);
    }

    private ClassLevelAbility(ClassLevelAbility ability) {
        super(ability);
        this.level = ability.level;
        this.manaString = ability.manaString;
    }

    @Override
    public ClassLevelAbility copy() {
        return new ClassLevelAbility(this);
    }

    @Override
    public String getRule() {
        return this.manaString + ": Level " + this.level;
    }

    @Override
    public ActivatedAbility.ActivationStatus canActivate(UUID playerId, Game game) {
        Permanent permanent = this.getSourcePermanentIfItStillExists(game);
        if (permanent != null && permanent.getClassLevel() == this.level - 1) {
            return super.canActivate(playerId, game);
        }
        return ActivatedAbility.ActivationStatus.getFalse();
    }
}

