/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.StaticAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.Costs;
import mage.abilities.costs.OptionalAdditionalCost;
import mage.abilities.costs.OptionalAdditionalCostImpl;
import mage.abilities.costs.OptionalAdditionalSourceCosts;
import mage.abilities.costs.common.CollectEvidenceCost;
import mage.abilities.hint.common.EvidenceHint;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

public class CollectEvidenceAbility
extends StaticAbility
implements OptionalAdditionalSourceCosts {
    private static final String promptString = "Collect evidence ";
    private static final String keywordText = "As an additional cost to cast this spell, you may collect evidence ";
    private static final String reminderText = "Exile cards with total mana value $$$ or greater from your graveyard";
    private final String rule;
    private final int amount;
    public static final String COLLECT_EVIDENCE_ACTIVATION_VALUE_KEY = "collectEvidenceActivation";
    protected OptionalAdditionalCost additionalCost;

    public static OptionalAdditionalCost makeCost(int amount) {
        OptionalAdditionalCostImpl cost = new OptionalAdditionalCostImpl(keywordText + amount, reminderText.replace("$$$", "" + amount), new CollectEvidenceCost(amount));
        cost.setRepeatable(false);
        return cost;
    }

    public CollectEvidenceAbility(int amount) {
        this(amount, null);
    }

    public CollectEvidenceAbility(int amount, String extraInfoText) {
        super(Zone.STACK, null);
        this.additionalCost = CollectEvidenceAbility.makeCost(amount);
        this.rule = this.additionalCost.getName() + ". " + (extraInfoText == null ? "" : extraInfoText + ". ") + this.additionalCost.getReminderText();
        this.setRuleAtTheTop(true);
        this.addHint(new EvidenceHint(amount));
        this.amount = amount;
    }

    private CollectEvidenceAbility(CollectEvidenceAbility ability) {
        super(ability);
        this.rule = ability.rule;
        this.additionalCost = ability.additionalCost.copy();
        this.amount = ability.amount;
    }

    @Override
    public CollectEvidenceAbility copy() {
        return new CollectEvidenceAbility(this);
    }

    public void resetCost() {
        if (this.additionalCost != null) {
            this.additionalCost.reset();
        }
    }

    @Override
    public void addOptionalAdditionalCosts(Ability ability, Game game) {
        if (!(ability instanceof SpellAbility)) {
            return;
        }
        Player player = game.getPlayer(ability.getControllerId());
        if (player == null) {
            return;
        }
        this.resetCost();
        boolean canPay = this.additionalCost.canPay(ability, this, ability.getControllerId(), game);
        if (!canPay || !player.chooseUse(Outcome.Exile, promptString + this.amount + '?', ability, game)) {
            return;
        }
        this.additionalCost.activate();
        for (Cost cost : (Costs)((Object)this.additionalCost)) {
            ability.getCosts().add(cost.copy());
        }
        ability.setCostsTag(COLLECT_EVIDENCE_ACTIVATION_VALUE_KEY, null);
    }

    @Override
    public String getCastMessageSuffix() {
        return this.additionalCost.getCastSuffixMessage(0);
    }

    @Override
    public String getRule() {
        return this.rule;
    }
}

