/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.MageObjectReference;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.keyword.CommanderStormEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.game.stack.StackObject;

public class CommanderStormAbility
extends TriggeredAbilityImpl {
    public CommanderStormAbility(boolean newTargetsText) {
        super(Zone.STACK, new CommanderStormEffect().setText("copy it for each time you've cast your commander from the command zone this game." + (newTargetsText ? " You may choose new targets for the copies." : "")));
        this.setTriggerPhrase("When you cast this spell, ");
        this.setRuleAtTheTop(true);
    }

    private CommanderStormAbility(CommanderStormAbility ability) {
        super(ability);
    }

    @Override
    public CommanderStormAbility copy() {
        return new CommanderStormAbility(this);
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        if (!event.getSourceId().equals(this.getSourceId())) {
            return false;
        }
        StackObject spell = game.getStack().getStackObject(this.getSourceId());
        if (!(spell instanceof Spell)) {
            return false;
        }
        for (Effect effect : this.getEffects()) {
            effect.setValue("StormSpell", spell);
            effect.setValue("StormSpellRef", new MageObjectReference(spell.getId(), game));
        }
        return true;
    }
}

