/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.CommanderCardType;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;
import mage.watchers.common.CommanderPlaysCountWatcher;

class CommanderStormEffect
extends OneShotEffect {
    CommanderStormEffect() {
        super(Outcome.Copy);
    }

    private CommanderStormEffect(CommanderStormEffect effect) {
        super(effect);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        MageObjectReference spellRef = (MageObjectReference)this.getValue("StormSpellRef");
        if (spellRef == null) {
            return false;
        }
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CommanderPlaysCountWatcher watcher = game.getState().getWatcher(CommanderPlaysCountWatcher.class);
        if (watcher == null) {
            return false;
        }
        int stormCount = game.getCommandersIds(player, CommanderCardType.COMMANDER_OR_OATHBREAKER, false).stream().mapToInt(watcher::getPlaysCount).sum();
        if (stormCount == 0) {
            return true;
        }
        Spell spell = (Spell)this.getValue("StormSpell");
        if (spell == null) {
            return false;
        }
        game.informPlayers(spell.getLogName() + " will be copied " + stormCount + " time" + (stormCount > 1 ? "s" : ""));
        spell.createCopyOnStack(game, source, source.getControllerId(), true, stormCount);
        return true;
    }

    @Override
    public CommanderStormEffect copy() {
        return new CommanderStormEffect(this);
    }
}

