/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.StaticAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.Costs;
import mage.abilities.costs.OptionalAdditionalCost;
import mage.abilities.costs.OptionalAdditionalCostImpl;
import mage.abilities.costs.OptionalAdditionalSourceCosts;
import mage.abilities.costs.VariableCostType;
import mage.abilities.costs.common.TapTargetCost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.keyword.ConspireTriggeredAbility;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.mageobject.SharesColorWithSourcePredicate;
import mage.filter.predicate.permanent.TappedPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetControlledPermanent;
import mage.util.CardUtil;

public class ConspireAbility
extends StaticAbility
implements OptionalAdditionalSourceCosts {
    private static final String keywordText = "Conspire";
    private static final FilterControlledPermanent filter = new FilterControlledPermanent("untapped creatures you control that share a color with it");
    private final UUID conspireId;
    private UUID addedById = null;
    private final String reminderText;
    private final OptionalAdditionalCost conspireCost;

    public ConspireAbility(ConspireTargets conspireTargets) {
        super(Zone.STACK, null);
        this.conspireId = UUID.randomUUID();
        this.reminderText = conspireTargets.getReminder();
        this.conspireCost = new OptionalAdditionalCostImpl(keywordText, " ", this.reminderText, new TapTargetCost(new TargetControlledPermanent(2, filter)));
        this.conspireCost.setCostType(VariableCostType.ADDITIONAL);
        this.addSubAbility(new ConspireTriggeredAbility(this.conspireId));
    }

    protected ConspireAbility(ConspireAbility ability) {
        super(ability);
        this.conspireId = ability.conspireId;
        this.addedById = ability.addedById;
        this.conspireCost = ability.conspireCost.copy();
        this.reminderText = ability.reminderText;
    }

    @Override
    public ConspireAbility copy() {
        return new ConspireAbility(this);
    }

    @Override
    public void addCost(Cost cost) {
        if (this.conspireCost != null) {
            ((Costs)((Object)this.conspireCost)).add(cost);
        }
    }

    @Override
    public boolean isActivated() {
        throw new UnsupportedOperationException("Use ConspireAbility.isActivated(Ability ability, Game game) method instead!");
    }

    @Override
    public void addOptionalAdditionalCosts(Ability ability, Game game) {
        if (!(ability instanceof SpellAbility)) {
            return;
        }
        Player player = game.getPlayer(this.getControllerId());
        if (player == null) {
            return;
        }
        if (!this.conspireCost.canPay(ability, this, this.getControllerId(), game) || !player.chooseUse(Outcome.Benefit, "Pay " + this.conspireCost.getText(false) + " ?", ability, game)) {
            return;
        }
        ability.getAllEffects().setValue("ConspireActivation" + this.conspireId + this.addedById, true);
        for (Cost cost : (Costs)((Object)this.conspireCost)) {
            if (cost instanceof ManaCostsImpl) {
                ability.addManaCostsToPay((ManaCostsImpl)cost.copy());
                continue;
            }
            ability.addCost(cost.copy());
        }
    }

    @Override
    public String getRule() {
        return "Conspire <i>(" + this.reminderText + ")</i>";
    }

    @Override
    public String getCastMessageSuffix() {
        return this.conspireCost != null ? this.conspireCost.getCastSuffixMessage(0) : "";
    }

    public ConspireAbility setAddedById(UUID addedById) {
        this.addedById = addedById;
        CardUtil.castStream(this.getSubAbilities().stream(), ConspireTriggeredAbility.class).forEach(ability -> ability.setAddedById(addedById));
        return this;
    }

    static {
        filter.add(TappedPredicate.UNTAPPED);
        filter.add(SharesColorWithSourcePredicate.instance);
        filter.add(CardType.CREATURE.getPredicate());
    }

    public static enum ConspireTargets {
        NONE(""),
        ONE(" and you may choose a new target for the copy"),
        MORE(" and you may choose new targets for the copy");

        private final String message;

        private ConspireTargets(String message) {
            this.message = message;
        }

        public String getReminder() {
            return "As you cast this spell, you may tap two untapped creatures you control that share a color with it. When you do, copy it" + this.message + ".";
        }
    }
}

