/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import java.util.UUID;
import mage.abilities.effects.common.CastSourceTriggeredAbility;
import mage.abilities.effects.common.CopySourceSpellEffect;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.util.CardUtil;

class ConspireTriggeredAbility
extends CastSourceTriggeredAbility {
    private final UUID conspireId;
    private UUID addedById = null;

    public ConspireTriggeredAbility(UUID conspireId) {
        super(new CopySourceSpellEffect(), false);
        this.setRuleVisible(false);
        this.conspireId = conspireId;
    }

    private ConspireTriggeredAbility(ConspireTriggeredAbility ability) {
        super(ability);
        this.conspireId = ability.conspireId;
        this.addedById = ability.addedById;
    }

    @Override
    public ConspireTriggeredAbility copy() {
        return new ConspireTriggeredAbility(this);
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        if (!super.checkTrigger(event, game)) {
            return false;
        }
        Spell spell = game.getStack().getSpell(event.getSourceId());
        return spell != null && CardUtil.getEffectValueFromAbility(spell.getSpellAbility(), "ConspireActivation" + this.conspireId + this.addedById, Boolean.class).orElse(false) != false;
    }

    @Override
    public String getRule() {
        return "When you pay the conspire costs, copy it and you may choose a new target for the copy.";
    }

    public void setAddedById(UUID addedById) {
        this.addedById = addedById;
    }
}

