/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import java.util.ArrayList;
import mage.Mana;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.costs.mana.ActivationManaAbilityStep;
import mage.abilities.costs.mana.AlternateManaPaymentAbility;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.dynamicvalue.common.PermanentsOnBattlefieldCount;
import mage.abilities.hint.ValueHint;
import mage.abilities.keyword.ConvokeSpecialAction;
import mage.abilities.mana.ManaOptions;
import mage.constants.AbilityType;
import mage.constants.Zone;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.filter.predicate.permanent.TappedPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetPermanent;

public class ConvokeAbility
extends SimpleStaticAbility
implements AlternateManaPaymentAbility {
    public static final String convokingCreaturesKey = "convokingCreatures";
    private static final FilterControlledCreaturePermanent filterUntapped = new FilterControlledCreaturePermanent();

    public ConvokeAbility() {
        super(Zone.ALL, null);
        this.setRuleAtTheTop(true);
        this.addHint(new ValueHint("Untapped creatures you control", new PermanentsOnBattlefieldCount(filterUntapped)));
    }

    protected ConvokeAbility(ConvokeAbility ability) {
        super(ability);
    }

    @Override
    public ConvokeAbility copy() {
        return new ConvokeAbility(this);
    }

    @Override
    public String getRule() {
        return "convoke <i>(Your creatures can help cast this spell. Each creature you tap while casting this spell pays for {1} or one mana of that creature's color.)</i>";
    }

    @Override
    public ActivationManaAbilityStep useOnActivationManaAbilityStep() {
        return ActivationManaAbilityStep.AFTER;
    }

    @Override
    public void addSpecialAction(Ability source, Game game, ManaCost unpaid) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && game.getBattlefield().containsControlled(filterUntapped, source, game, 1) && source.getAbilityType() == AbilityType.SPELL) {
            ConvokeSpecialAction specialAction = new ConvokeSpecialAction(unpaid, (AlternateManaPaymentAbility)this);
            specialAction.setControllerId(source.getControllerId());
            specialAction.setSourceId(source.getSourceId());
            FilterControlledCreaturePermanent filter = new FilterControlledCreaturePermanent();
            filter.add(TappedPredicate.UNTAPPED);
            if (unpaid.getMana().getGeneric() == 0) {
                ArrayList<ColorPredicate> colorPredicates = new ArrayList<ColorPredicate>();
                if (unpaid.getMana().getBlack() > 0) {
                    colorPredicates.add(new ColorPredicate(ObjectColor.BLACK));
                }
                if (unpaid.getMana().getBlue() > 0) {
                    colorPredicates.add(new ColorPredicate(ObjectColor.BLUE));
                }
                if (unpaid.getMana().getRed() > 0) {
                    colorPredicates.add(new ColorPredicate(ObjectColor.RED));
                }
                if (unpaid.getMana().getGreen() > 0) {
                    colorPredicates.add(new ColorPredicate(ObjectColor.GREEN));
                }
                if (unpaid.getMana().getWhite() > 0) {
                    colorPredicates.add(new ColorPredicate(ObjectColor.WHITE));
                }
                filter.add(Predicates.or(colorPredicates));
            }
            TargetPermanent target = new TargetPermanent(1, 1, filter, true);
            target.withTargetName("creature to tap for convoke");
            specialAction.addTarget(target);
            if (specialAction.canActivate(source.getControllerId(), game).canActivate()) {
                game.getState().getSpecialActions().add(specialAction);
            }
        }
    }

    @Override
    public ManaOptions getManaOptions(Ability source, Game game, ManaCost unpaid) {
        ManaOptions options = new ManaOptions();
        FilterControlledCreaturePermanent filterBasic = new FilterControlledCreaturePermanent();
        game.getBattlefield().getActivePermanents(filterBasic, source.getControllerId(), source, game).stream().filter(permanent -> !permanent.isTapped()).forEach(permanent -> {
            ManaOptions permMana = new ManaOptions();
            permMana.add(Mana.GenericMana(1));
            for (ObjectColor color : permanent.getColor(game).getColors()) {
                if (color.isBlack()) {
                    permMana.add(Mana.BlackMana(1));
                }
                if (color.isBlue()) {
                    permMana.add(Mana.BlueMana(1));
                }
                if (color.isGreen()) {
                    permMana.add(Mana.GreenMana(1));
                }
                if (color.isRed()) {
                    permMana.add(Mana.RedMana(1));
                }
                if (!color.isWhite()) continue;
                permMana.add(Mana.WhiteMana(1));
            }
            options.addMana(permMana);
        });
        options.removeFullyIncludedVariations();
        return options;
    }

    static {
        filterUntapped.add(TappedPredicate.UNTAPPED);
    }
}

