/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.MageObject;
import mage.abilities.ActivatedAbilityImpl;
import mage.abilities.costs.common.ExileSourceCost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.keyword.CraftCost;
import mage.abilities.keyword.CraftEffect;
import mage.abilities.keyword.TransformAbility;
import mage.constants.CardType;
import mage.constants.TargetController;
import mage.constants.TimingRule;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterArtifactCard;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.common.FilterOwnedCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.target.common.TargetCardInGraveyardBattlefieldOrStack;

public class CraftAbility
extends ActivatedAbilityImpl {
    private static final FilterCard artifactFilter = new FilterArtifactCard("artifact");
    private final String description;
    private final String manaString;

    public CraftAbility(String manaString) {
        this(manaString, "artifact", "another artifact you control or an artifact card from your graveyard", CardType.ARTIFACT.getPredicate());
    }

    public CraftAbility(String manaString, String description, String targetDescription, Predicate<MageObject> ... predicates) {
        this(manaString, description, targetDescription, 1, 1, predicates);
    }

    public CraftAbility(String manaString, String description, String targetDescription, int minTargets, int maxTargets, Predicate<MageObject> ... predicates) {
        this(manaString, description, CraftAbility.makeTarget(minTargets, maxTargets, targetDescription, predicates));
    }

    public CraftAbility(String manaString, String description, TargetCardInGraveyardBattlefieldOrStack target) {
        super(Zone.BATTLEFIELD, new CraftEffect(), new ManaCostsImpl(manaString));
        this.addCost(new ExileSourceCost());
        this.addCost(new CraftCost(target));
        this.addSubAbility(new TransformAbility());
        this.timing = TimingRule.SORCERY;
        this.manaString = manaString;
        this.description = description;
    }

    private CraftAbility(CraftAbility ability) {
        super(ability);
        this.manaString = ability.manaString;
        this.description = ability.description;
    }

    @Override
    public CraftAbility copy() {
        return new CraftAbility(this);
    }

    @Override
    public String getRule() {
        return "Craft with " + this.description + ' ' + this.manaString;
    }

    private static TargetCardInGraveyardBattlefieldOrStack makeTarget(int minTargets, int maxTargets, String targetDescription, Predicate<MageObject> ... predicates) {
        FilterControlledPermanent filterPermanent = new FilterControlledPermanent();
        filterPermanent.add(AnotherPredicate.instance);
        FilterOwnedCard filterCard = new FilterOwnedCard();
        for (Predicate<MageObject> predicate : predicates) {
            filterPermanent.add(predicate);
            filterCard.add(predicate);
        }
        return new TargetCardInGraveyardBattlefieldOrStack(minTargets, maxTargets, filterCard, filterPermanent, targetDescription);
    }

    static {
        artifactFilter.add(TargetController.YOU.getOwnerPredicate());
    }
}

