/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import java.util.UUID;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.filter.predicate.ObjectSourcePlayer;
import mage.filter.predicate.other.PlayerWithTheMostLifePredicate;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;

public class DethroneAbility
extends TriggeredAbilityImpl {
    public DethroneAbility() {
        super(Zone.BATTLEFIELD, new AddCountersSourceEffect(CounterType.P1P1.createInstance()), false);
    }

    protected DethroneAbility(DethroneAbility ability) {
        super(ability);
    }

    @Override
    public DethroneAbility copy() {
        return new DethroneAbility(this);
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DECLARED_ATTACKERS;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        UUID defenderId = game.getCombat().getDefenderId(this.getSourceId());
        if (defenderId == null) {
            return false;
        }
        Player attackedPlayer = game.getPlayer(defenderId);
        return PlayerWithTheMostLifePredicate.instance.apply(new ObjectSourcePlayer<Player>(attackedPlayer, this.getControllerId(), null), game);
    }

    @Override
    public String getRule() {
        return "Dethrone (<i>Whenever this creature attacks the player with the most life or tied for most life, put a +1/+1 counter on it.</i>)";
    }
}

