/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.ActivatedAbility;
import mage.abilities.common.PutIntoGraveFromAnywhereSourceAbility;
import mage.abilities.common.SpellTransformedAbility;
import mage.abilities.effects.common.ExileSourceEffect;
import mage.cards.Card;
import mage.constants.SpellAbilityCastMode;
import mage.constants.Zone;
import mage.game.Game;

public class DisturbAbility
extends SpellTransformedAbility {
    public DisturbAbility(Card card, String manaCost) {
        super(card, manaCost);
        this.zone = Zone.GRAVEYARD;
        this.setSpellAbilityCastMode(SpellAbilityCastMode.DISTURB);
    }

    private DisturbAbility(DisturbAbility ability) {
        super(ability);
    }

    @Override
    public DisturbAbility copy() {
        return new DisturbAbility(this);
    }

    @Override
    public ActivatedAbility.ActivationStatus canActivate(UUID playerId, Game game) {
        Card card;
        if (super.canActivate(playerId, game).canActivate() && (card = game.getCard(this.getSourceId())) != null && game.getState().getZone(card.getId()) == Zone.GRAVEYARD) {
            return card.getSpellAbility().canActivate(playerId, game);
        }
        return ActivatedAbility.ActivationStatus.getFalse();
    }

    @Override
    public String getRule(boolean all) {
        return this.getRule();
    }

    @Override
    public String getRule() {
        return "Disturb " + this.manaCost + " <i>(You may cast this card transformed from your graveyard for its disturb cost.)</i>";
    }

    public static Ability makeBackAbility() {
        return new PutIntoGraveFromAnywhereSourceAbility(new ExileSourceEffect().setText("exile it instead"));
    }
}

