/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import java.util.HashSet;
import java.util.Iterator;
import java.util.UUID;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.dynamicvalue.common.OpponentsCount;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.EncoreRequirementEffect;
import mage.abilities.keyword.EncoreSacrificeEffect;
import mage.abilities.keyword.HasteAbility;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.token.Token;
import mage.target.targetpointer.FixedTarget;
import mage.util.functions.CopyTokenFunction;

class EncoreEffect
extends OneShotEffect {
    EncoreEffect() {
        super(Outcome.PutCreatureInPlay);
    }

    private EncoreEffect(EncoreEffect effect) {
        super(effect);
    }

    @Override
    public EncoreEffect copy() {
        return new EncoreEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Card card = game.getCard(source.getSourceId());
        if (card == null) {
            return false;
        }
        Token token = CopyTokenFunction.createTokenCopy(card, game);
        HashSet<MageObjectReference> addedTokens = new HashSet<MageObjectReference>();
        int opponentCount = OpponentsCount.instance.calculate(game, source, this);
        if (opponentCount < 1) {
            return false;
        }
        token.putOntoBattlefield(opponentCount, game, source, source.getControllerId());
        Iterator<UUID> it = token.getLastAddedTokenIds().iterator();
        while (it.hasNext()) {
            for (UUID playerId : game.getOpponents(source.getControllerId())) {
                if (game.getPlayer(playerId) == null) continue;
                UUID tokenId = it.next();
                MageObjectReference mageObjectReference = new MageObjectReference(tokenId, game);
                game.addEffect(new EncoreRequirementEffect(mageObjectReference, playerId), source);
                game.addEffect(new GainAbilityTargetEffect(HasteAbility.getInstance(), Duration.Custom).setTargetPointer(new FixedTarget(mageObjectReference)), source);
                addedTokens.add(mageObjectReference);
            }
        }
        game.addDelayedTriggeredAbility(new AtTheBeginOfNextEndStepDelayedTriggeredAbility(new EncoreSacrificeEffect(addedTokens)), source);
        return true;
    }
}

