/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import java.util.Set;
import java.util.UUID;
import mage.MageIdentifier;
import mage.abilities.ActivatedAbility;
import mage.abilities.SpellAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.Costs;
import mage.abilities.costs.CostsImpl;
import mage.abilities.costs.common.ExileFromGraveCost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.cards.Card;
import mage.constants.SpellAbilityType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.game.Game;
import mage.target.common.TargetCardInYourGraveyard;
import mage.util.CardUtil;

public class EscapeAbility
extends SpellAbility {
    private static final FilterCard filter = new FilterCard("card to exile");
    private static final String CASTED_WITH_ESCAPE_KEY = "escapeActivated";
    private final String staticText;

    public EscapeAbility(Card card, String manaCost, int exileCount) {
        this(card, manaCost, new CostsImpl<Cost>(), exileCount);
    }

    public EscapeAbility(Card card, String manaCost, Costs<Cost> additionalCost) {
        this(card, manaCost, additionalCost, 0);
    }

    public EscapeAbility(Card card, String manaCost, Costs<Cost> additionalCosts, int exileCount) {
        super(card.getSpellAbility());
        this.newId();
        this.setCardName(card.getName() + " with Escape");
        this.zone = Zone.GRAVEYARD;
        this.spellAbilityType = SpellAbilityType.BASE_ALTERNATE;
        this.clearManaCosts();
        this.clearManaCostsToPay();
        this.addCost(new ManaCostsImpl(manaCost));
        for (Cost cost : additionalCosts) {
            this.addCost(cost.copy().setText(""));
        }
        if (exileCount > 0) {
            this.addCost(new ExileFromGraveCost(new TargetCardInYourGraveyard(exileCount, filter), ""));
        }
        String text = "Escape&mdash;" + manaCost;
        for (Cost cost : additionalCosts) {
            text = text + ", " + CardUtil.getTextWithFirstCharUpperCase(cost.getText());
        }
        if (exileCount > 0) {
            text = text + ", Exile " + CardUtil.numberToText(exileCount) + " other cards from your graveyard";
        }
        this.staticText = text = text + ". <i>(You may cast this card from your graveyard for its escape cost.)</i>";
    }

    private EscapeAbility(EscapeAbility ability) {
        super(ability);
        this.staticText = ability.staticText;
    }

    @Override
    public EscapeAbility copy() {
        return new EscapeAbility(this);
    }

    @Override
    public String getRule(boolean all) {
        return this.getRule();
    }

    @Override
    public String getRule() {
        return this.staticText;
    }

    @Override
    public ActivatedAbility.ActivationStatus canActivate(UUID playerId, Game game) {
        if (game.getState().getZone(this.getSourceId()) != Zone.GRAVEYARD) {
            return ActivatedAbility.ActivationStatus.getFalse();
        }
        return super.canActivate(playerId, game);
    }

    @Override
    public boolean activate(Game game, Set<MageIdentifier> allowedIdentifiers, boolean noMana) {
        if (super.activate(game, allowedIdentifiers, noMana)) {
            game.getState().setValue(CASTED_WITH_ESCAPE_KEY + this.getSourceId().toString() + (this.getStackMomentSourceZCC() + 1), Boolean.TRUE);
            return true;
        }
        return false;
    }

    public static boolean wasCastedWithEscape(Game game, UUID sourceId, int sourceZCC) {
        Object activated = game.getState().getValue(CASTED_WITH_ESCAPE_KEY + sourceId.toString() + sourceZCC);
        return activated != null;
    }

    static {
        filter.add(AnotherPredicate.instance);
    }
}

