/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.common.EntersBattlefieldAllTriggeredAbility;
import mage.abilities.keyword.EvolveEffect;
import mage.constants.Zone;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

public class EvolveAbility
extends EntersBattlefieldAllTriggeredAbility {
    public EvolveAbility() {
        super(Zone.BATTLEFIELD, new EvolveEffect(), StaticFilters.FILTER_CONTROLLED_CREATURE, false);
    }

    public EvolveAbility(EvolveAbility ability) {
        super(ability);
    }

    @Override
    public boolean checkInterveningIfClause(Game game) {
        Permanent sourcePermanent = this.getSourcePermanentOrLKI(game);
        return sourcePermanent != null && sourcePermanent.isCreature(game) && CardUtil.getEffectValueFromAbility(this, "permanentEnteringBattlefield", Permanent.class).filter(permanent -> permanent.isCreature(game)).filter(permanent -> sourcePermanent.getPower().getValue() < permanent.getPower().getValue() || sourcePermanent.getToughness().getValue() < permanent.getToughness().getValue()).isPresent();
    }

    @Override
    public String getRule() {
        return "Evolve <i>(Whenever a creature you control enters, if that creature has greater power or toughness than this creature, put a +1/+1 counter on this creature.)</i>";
    }

    @Override
    public EvolveAbility copy() {
        return new EvolveAbility(this);
    }
}

