/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.abilities.effects.common.DontUntapInControllersNextUntapStepTargetEffect;
import mage.abilities.keyword.ExertedThisTurnWatcher;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;

class ExertReplacementEffect
extends ReplacementEffectImpl {
    private final boolean exertOnlyOncePerTurn;

    public ExertReplacementEffect(boolean exertOnlyOncePerTurn) {
        super(Duration.WhileOnBattlefield, Outcome.Detriment);
        this.staticText = "You may exert {this} as it attacks";
        this.exertOnlyOncePerTurn = exertOnlyOncePerTurn;
    }

    private ExertReplacementEffect(ExertReplacementEffect effect) {
        super(effect);
        this.exertOnlyOncePerTurn = effect.exertOnlyOncePerTurn;
    }

    @Override
    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ATTACKER_DECLARED;
    }

    @Override
    public boolean applies(GameEvent event, Ability source, Game game) {
        return event.getSourceId().equals(source.getSourceId());
    }

    @Override
    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Permanent creature = game.getPermanent(event.getSourceId());
        Player controller = game.getPlayer(source.getControllerId());
        if (creature != null && controller != null) {
            if (this.exertOnlyOncePerTurn) {
                MageObjectReference creatureReference = new MageObjectReference(creature.getId(), creature.getZoneChangeCounter(game), game);
                ExertedThisTurnWatcher watcher = game.getState().getWatcher(ExertedThisTurnWatcher.class);
                if (watcher != null && watcher.getExertedThisTurnCreatures().contains(creatureReference)) {
                    return false;
                }
            }
            if (controller.chooseUse(this.outcome, "Exert " + creature.getLogName() + '?', "An exerted creature won't untap during your next untap step.", "Yes", "No", source, game)) {
                if (!game.isSimulation()) {
                    game.informPlayers(controller.getLogName() + " exerted " + creature.getName());
                }
                game.fireEvent(GameEvent.getEvent(GameEvent.EventType.BECOMES_EXERTED, creature.getId(), source, source.getControllerId()));
                DontUntapInControllersNextUntapStepTargetEffect effect = new DontUntapInControllersNextUntapStepTargetEffect("", creature.getControllerId());
                effect.setTargetPointer(new FixedTarget(creature, game));
                game.addEffect(effect, source);
            }
        }
        return false;
    }

    @Override
    public String getText(Mode mode) {
        return this.staticText;
    }

    @Override
    public ExertReplacementEffect copy() {
        return new ExertReplacementEffect(this);
    }
}

