/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.common.TargetSacrifice;

class ExploitEffect
extends OneShotEffect {
    public ExploitEffect() {
        super(Outcome.Detriment);
        this.staticText = "you may sacrifice a creature";
    }

    protected ExploitEffect(ExploitEffect effect) {
        super(effect);
    }

    @Override
    public ExploitEffect copy() {
        return new ExploitEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            TargetSacrifice target = new TargetSacrifice(StaticFilters.FILTER_PERMANENT_A_CREATURE);
            target.withChooseHint("to exploit");
            if (target.canChoose(controller.getId(), source, game)) {
                controller.choose(Outcome.Sacrifice, target, source, game);
                Permanent permanent = game.getPermanent(target.getFirstTarget());
                if (permanent != null && permanent.sacrifice(source, game)) {
                    game.fireEvent(GameEvent.getEvent(GameEvent.EventType.EXPLOITED_CREATURE, permanent.getId(), source, controller.getId()));
                }
            }
            return true;
        }
        return false;
    }
}

