/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.token.ServoToken;
import mage.players.Player;
import mage.util.CardUtil;

class FabricateEffect
extends OneShotEffect {
    private final int value;

    FabricateEffect(int value) {
        super(Outcome.Benefit);
        this.value = value;
    }

    FabricateEffect(FabricateEffect effect) {
        super(effect);
        this.value = effect.value;
    }

    @Override
    public FabricateEffect copy() {
        return new FabricateEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Card card = source.getSourceCardIfItStillExists(game);
            if (card != null && controller.chooseUse(Outcome.BoostCreature, "Fabricate " + this.value, null, "Put " + CardUtil.getOneOneCountersText(this.value), "Create " + CardUtil.numberToText(this.value, "a") + " 1/1 token" + (this.value > 1 ? "s" : ""), source, game)) {
                card.addCounters(CounterType.P1P1.createInstance(this.value), source.getControllerId(), source, game);
            } else {
                new ServoToken().putOntoBattlefield(this.value, game, source, controller.getId());
            }
            return true;
        }
        return false;
    }
}

