/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import java.util.UUID;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.ForetellCostAbility;
import mage.cards.Card;
import mage.cards.CardWithSpellOption;
import mage.cards.ModalDoubleFacedCard;
import mage.cards.ModalDoubleFacedCardHalf;
import mage.cards.SpellOptionCard;
import mage.cards.SplitCard;
import mage.cards.SplitCardHalf;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.Zone;
import mage.game.Game;

class ForetellAddCostEffect
extends ContinuousEffectImpl {
    private final MageObjectReference mor;

    ForetellAddCostEffect(MageObjectReference mor) {
        super(Duration.EndOfGame, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.mor = mor;
        this.staticText = "Foretold card";
    }

    private ForetellAddCostEffect(ForetellAddCostEffect effect) {
        super(effect);
        this.mor = effect.mor;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Card card = this.mor.getCard(game);
        if (card != null) {
            UUID mainCardId = card.getMainCard().getId();
            if (game.getState().getZone(mainCardId) == Zone.EXILED) {
                String foretellCost = (String)game.getState().getValue(mainCardId.toString() + "Foretell Cost");
                String foretellSplitCost = (String)game.getState().getValue(mainCardId.toString() + "Foretell Split Cost");
                if (card instanceof SplitCard) {
                    ForetellCostAbility ability;
                    if (foretellCost != null) {
                        SplitCardHalf leftHalfCard = ((SplitCard)card).getLeftHalfCard();
                        ability = new ForetellCostAbility(foretellCost);
                        ability.setSourceId(leftHalfCard.getId());
                        ability.setControllerId(source.getControllerId());
                        ability.setSpellAbilityType(leftHalfCard.getSpellAbility().getSpellAbilityType());
                        ability.setAbilityName(leftHalfCard.getName());
                        game.getState().addOtherAbility(leftHalfCard, ability);
                    }
                    if (foretellSplitCost != null) {
                        SplitCardHalf rightHalfCard = ((SplitCard)card).getRightHalfCard();
                        ability = new ForetellCostAbility(foretellSplitCost);
                        ability.setSourceId(rightHalfCard.getId());
                        ability.setControllerId(source.getControllerId());
                        ability.setSpellAbilityType(rightHalfCard.getSpellAbility().getSpellAbilityType());
                        ability.setAbilityName(rightHalfCard.getName());
                        game.getState().addOtherAbility(rightHalfCard, ability);
                    }
                } else if (card instanceof ModalDoubleFacedCard) {
                    ModalDoubleFacedCardHalf rightHalfCard;
                    ForetellCostAbility ability;
                    ModalDoubleFacedCardHalf leftHalfCard;
                    if (foretellCost != null && !(leftHalfCard = ((ModalDoubleFacedCard)card).getLeftHalfCard()).isLand(game)) {
                        ability = new ForetellCostAbility(foretellCost);
                        ability.setSourceId(leftHalfCard.getId());
                        ability.setControllerId(source.getControllerId());
                        ability.setSpellAbilityType(leftHalfCard.getSpellAbility().getSpellAbilityType());
                        ability.setAbilityName(leftHalfCard.getName());
                        game.getState().addOtherAbility(leftHalfCard, ability);
                    }
                    if (foretellSplitCost != null && !(rightHalfCard = ((ModalDoubleFacedCard)card).getRightHalfCard()).isLand(game)) {
                        ability = new ForetellCostAbility(foretellSplitCost);
                        ability.setSourceId(rightHalfCard.getId());
                        ability.setControllerId(source.getControllerId());
                        ability.setSpellAbilityType(rightHalfCard.getSpellAbility().getSpellAbilityType());
                        ability.setAbilityName(rightHalfCard.getName());
                        game.getState().addOtherAbility(rightHalfCard, ability);
                    }
                } else if (card instanceof CardWithSpellOption) {
                    ForetellCostAbility ability;
                    if (foretellCost != null) {
                        Card creatureCard = card.getMainCard();
                        ability = new ForetellCostAbility(foretellCost);
                        ability.setSourceId(creatureCard.getId());
                        ability.setControllerId(source.getControllerId());
                        ability.setSpellAbilityType(creatureCard.getSpellAbility().getSpellAbilityType());
                        ability.setAbilityName(creatureCard.getName());
                        game.getState().addOtherAbility(creatureCard, ability);
                    }
                    if (foretellSplitCost != null) {
                        SpellOptionCard spellCard = ((CardWithSpellOption)card).getSpellCard();
                        ability = new ForetellCostAbility(foretellSplitCost);
                        ability.setSourceId(spellCard.getId());
                        ability.setControllerId(source.getControllerId());
                        ability.setSpellAbilityType(spellCard.getSpellAbility().getSpellAbilityType());
                        ability.setAbilityName(spellCard.getName());
                        game.getState().addOtherAbility(spellCard, ability);
                    }
                } else if (foretellCost != null) {
                    ForetellCostAbility ability = new ForetellCostAbility(foretellCost);
                    ability.setSourceId(card.getId());
                    ability.setControllerId(source.getControllerId());
                    ability.setSpellAbilityType(card.getSpellAbility().getSpellAbilityType());
                    ability.setAbilityName(card.getName());
                    game.getState().addOtherAbility(card, ability);
                }
                return true;
            }
        }
        this.discard();
        return true;
    }

    @Override
    public ForetellAddCostEffect copy() {
        return new ForetellAddCostEffect(this);
    }
}

