/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import java.util.UUID;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ExileTargetEffect;
import mage.abilities.keyword.ForetellAddCostEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.util.CardUtil;

class ForetellExileEffect
extends OneShotEffect {
    private final Card card;
    String foretellCost;
    String foretellSplitCost;

    ForetellExileEffect(Card card, String foretellCost, String foretellSplitCost) {
        super(Outcome.Neutral);
        this.card = card;
        this.foretellCost = foretellCost;
        this.foretellSplitCost = foretellSplitCost;
    }

    private ForetellExileEffect(ForetellExileEffect effect) {
        super(effect);
        this.card = effect.card;
        this.foretellCost = effect.foretellCost;
        this.foretellSplitCost = effect.foretellSplitCost;
    }

    @Override
    public ForetellExileEffect copy() {
        return new ForetellExileEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && this.card != null) {
            UUID mainCardId = this.card.getMainCard().getId();
            UUID exileId = CardUtil.getExileZoneId(mainCardId.toString() + "foretellAbility", game);
            ExileTargetEffect effect = new ExileTargetEffect(exileId, " Foretell Turn Number: " + game.getTurnNum());
            game.getState().setValue(mainCardId.toString() + "Foretell Turn Number", game.getTurnNum());
            game.getState().setValue(mainCardId.toString() + "Foretell Cost", this.foretellCost);
            game.getState().setValue(mainCardId.toString() + "Foretell Split Cost", this.foretellSplitCost);
            effect.setWithName(false);
            effect.setTargetPointer(new FixedTarget(this.card.getId(), game));
            effect.apply(game, source);
            this.card.setFaceDown(true, game);
            game.addEffect(new ForetellAddCostEffect(new MageObjectReference(this.card, game)), source);
            game.fireEvent(new GameEvent(GameEvent.EventType.CARD_FORETOLD, this.card.getId(), source, source.getControllerId(), 0, true));
            return true;
        }
        return false;
    }
}

