/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.constants.SubType;
import mage.constants.WatcherScope;
import mage.filter.predicate.mageobject.CommanderPredicate;
import mage.game.Game;
import mage.game.events.DamagedEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.watchers.Watcher;

class FreerunningWatcher
extends Watcher {
    private final Set<UUID> players = new HashSet<UUID>();

    FreerunningWatcher() {
        super(WatcherScope.GAME);
    }

    @Override
    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.DAMAGED_PLAYER || !((DamagedEvent)event).isCombatDamage()) {
            return;
        }
        Permanent permanent = game.getPermanentOrLKIBattlefield(event.getSourceId());
        if (permanent != null && (permanent.hasSubtype(SubType.ASSASSIN, game) || CommanderPredicate.instance.apply(permanent, game))) {
            this.players.add(permanent.getControllerId());
        }
    }

    @Override
    public void reset() {
        this.players.clear();
        super.reset();
    }

    static boolean checkPlayer(UUID playerId, Game game) {
        return game.getState().getWatcher(FreerunningWatcher.class).players.contains(playerId);
    }
}

