/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import java.util.Locale;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.keyword.GraftDistributeCounterEffect;
import mage.abilities.keyword.GraftStaticAbility;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.filter.common.FilterCreaturePermanent;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.util.CardUtil;

public class GraftAbility
extends TriggeredAbilityImpl {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent();
    private int amount;
    private String cardtype;

    public GraftAbility(Card card, int amount) {
        super(Zone.BATTLEFIELD, new GraftDistributeCounterEffect(), true);
        this.amount = amount;
        StringBuilder sb = new StringBuilder();
        for (CardType theCardtype : card.getCardType()) {
            sb.append(theCardtype.toString().toLowerCase(Locale.ENGLISH)).append(' ');
        }
        this.cardtype = sb.toString().trim();
        this.addSubAbility(new GraftStaticAbility(amount));
    }

    protected GraftAbility(GraftAbility ability) {
        super(ability);
        this.amount = ability.amount;
        this.cardtype = ability.cardtype;
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent sourcePermanent = game.getPermanent(this.getSourceId());
        Permanent permanent = game.getPermanent(event.getTargetId());
        if (sourcePermanent != null && permanent != null && !sourcePermanent.getId().equals(permanent.getId()) && sourcePermanent.getCounters(game).containsKey(CounterType.P1P1) && filter.match(permanent, game)) {
            for (Effect effect : this.getEffects()) {
                effect.setTargetPointer(new FixedTarget(event.getTargetId(), game));
            }
            return true;
        }
        return false;
    }

    @Override
    public GraftAbility copy() {
        return new GraftAbility(this);
    }

    @Override
    public String getRule() {
        return "Graft " + this.amount + " <i>(This " + this.cardtype + " enters the battlefield with " + CardUtil.getOneOneCountersText(this.amount) + " on it. Whenever " + (this.cardtype.contains("creature") ? "another" : "a") + " creature enters the battlefield, you may move a +1/+1 counter from this " + this.cardtype + " onto it.)</i>";
    }
}

