/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;

class HauntEffect
extends OneShotEffect {
    HauntEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile it haunting target creature";
    }

    private HauntEffect(HauntEffect effect) {
        super(effect);
    }

    @Override
    public HauntEffect copy() {
        return new HauntEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Card card = game.getCard(source.getSourceId());
        if (player == null || card == null) {
            return false;
        }
        Permanent hauntedCreature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (hauntedCreature == null) {
            return false;
        }
        if (!player.moveCards(card, Zone.EXILED, source, game)) {
            return true;
        }
        String key = "Haunting_" + source.getSourceId().toString() + (card.getZoneChangeCounter(game) + hauntedCreature.getZoneChangeCounter(game));
        game.getState().setValue(key, new FixedTarget(this.getTargetPointer().getFirst(game, source), game));
        card.addInfo("hauntinfo", "Haunting " + hauntedCreature.getLogName(), game);
        hauntedCreature.addInfo("hauntinfo", "Haunted by " + card.getLogName(), game);
        game.informPlayers(card.getName() + " haunting " + hauntedCreature.getLogName());
        return true;
    }
}

