/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class IngestEffect
extends OneShotEffect {
    public IngestEffect() {
        super(Outcome.Exile);
        this.staticText = "that player exiles the top card of their library";
    }

    protected IngestEffect(IngestEffect effect) {
        super(effect);
    }

    @Override
    public IngestEffect copy() {
        return new IngestEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player targetPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (targetPlayer != null) {
            Card card = targetPlayer.getLibrary().getFromTop(game);
            if (card != null) {
                targetPlayer.moveCards(card, Zone.EXILED, source, game);
            }
            return true;
        }
        return false;
    }
}

