/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.Ability;
import mage.abilities.MageSingleton;
import mage.abilities.effects.RestrictionEffect;
import mage.abilities.keyword.IntimidateAbility;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.permanent.Permanent;

class IntimidateEffect
extends RestrictionEffect
implements MageSingleton {
    public IntimidateEffect() {
        super(Duration.EndOfGame);
    }

    protected IntimidateEffect(IntimidateEffect effect) {
        super(effect);
    }

    @Override
    public boolean applies(Permanent permanent, Ability source, Game game) {
        return permanent.getAbilities().containsKey(IntimidateAbility.getInstance().getId());
    }

    @Override
    public boolean canBeBlocked(Permanent attacker, Permanent blocker, Ability source, Game game, boolean canUseChooseDialogs) {
        boolean result = false;
        if (blocker.isArtifact(game) && blocker.isCreature(game)) {
            result = true;
        }
        if (attacker.getColor(game).shares(blocker.getColor(game))) {
            result = true;
        }
        return result;
    }

    @Override
    public IntimidateEffect copy() {
        return new IntimidateEffect(this);
    }
}

