/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import mage.abilities.Abilities;
import mage.abilities.AbilitiesImpl;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.condition.CompoundCondition;
import mage.abilities.condition.common.SourceHasCounterCondition;
import mage.abilities.decorator.ConditionalContinuousEffect;
import mage.abilities.effects.common.continuous.GainAbilitySourceEffect;
import mage.abilities.effects.common.continuous.SetBasePowerToughnessSourceEffect;
import mage.constants.ComparisonType;
import mage.constants.Duration;
import mage.counters.CounterType;

public class LevelerCardBuilder {
    private int level1;
    private int level2;
    private int power;
    private int toughness;
    private String rule = "";
    private Abilities<Ability> abilities = new AbilitiesImpl<Ability>();

    public List<Ability> build() {
        ArrayList<Ability> constructed = new ArrayList<Ability>();
        CompoundCondition condition = new CompoundCondition("", new SourceHasCounterCondition(CounterType.LEVEL, ComparisonType.OR_GREATER, this.level1), new SourceHasCounterCondition(CounterType.LEVEL, ComparisonType.OR_LESS, this.level2));
        for (Ability ability : this.abilities) {
            GainAbilitySourceEffect effect = new GainAbilitySourceEffect(ability);
            ConditionalContinuousEffect abEffect = new ConditionalContinuousEffect(effect, condition, "");
            SimpleStaticAbility staticAbility = new SimpleStaticAbility(abEffect);
            staticAbility.setRuleVisible(false);
            constructed.add(staticAbility);
        }
        SetBasePowerToughnessSourceEffect effect = new SetBasePowerToughnessSourceEffect(this.power, this.toughness, Duration.WhileOnBattlefield);
        ConditionalContinuousEffect ptEffect = new ConditionalContinuousEffect(effect, condition, this.rule);
        constructed.add(new SimpleStaticAbility(ptEffect));
        return constructed;
    }

    public LevelerCardBuilder setLevel1(int level1) {
        this.level1 = level1;
        return this;
    }

    public LevelerCardBuilder setLevel2(int level2) {
        this.level2 = level2;
        return this;
    }

    public LevelerCardBuilder setPower(int power) {
        this.power = power;
        return this;
    }

    public LevelerCardBuilder setToughness(int toughness) {
        this.toughness = toughness;
        return this;
    }

    public LevelerCardBuilder addAbility(Ability ability) {
        this.abilities.add(ability);
        return this;
    }

    public LevelerCardBuilder setRule(String rule) {
        this.rule = rule;
        return this;
    }

    public LevelerCardBuilder reset() {
        this.level1 = 0;
        this.level2 = 0;
        this.power = 0;
        this.toughness = 0;
        this.abilities.clear();
        this.rule = "";
        return this;
    }

    public static List<Ability> construct(LevelAbility ... levelAbilities) {
        LevelerCardBuilder builder = new LevelerCardBuilder();
        ArrayList<Ability> abilities = new ArrayList<Ability>();
        for (LevelAbility levelAbility : levelAbilities) {
            builder = builder.reset().setLevel1(levelAbility.getLevel1()).setLevel2(levelAbility.getLevel2() == -1 ? Integer.MAX_VALUE : levelAbility.getLevel2()).setPower(levelAbility.getPower()).setToughness(levelAbility.getToughness()).setRule(levelAbility.getRule());
            for (Ability addedAbility : levelAbility.getAbilities()) {
                builder.addAbility(addedAbility);
            }
            abilities.addAll(builder.build());
        }
        return abilities;
    }

    public static class LevelAbility {
        private final int level1;
        private final int level2;
        private final int power;
        private final int toughness;
        private Abilities<Ability> abilities = new AbilitiesImpl<Ability>();

        public LevelAbility(int level1, int level2, Abilities<Ability> abilities, int power, int toughness) {
            this.level1 = level1;
            this.level2 = level2;
            this.abilities.addAll(abilities);
            this.power = power;
            this.toughness = toughness;
        }

        public LevelAbility(LevelAbility ability) {
            this.level1 = ability.level1;
            this.level2 = ability.level2;
            this.abilities = ability.abilities.copy();
            this.power = ability.power;
            this.toughness = ability.toughness;
        }

        public int getLevel1() {
            return this.level1;
        }

        public int getLevel2() {
            return this.level2;
        }

        public Abilities<Ability> getAbilities() {
            return this.abilities;
        }

        public int getPower() {
            return this.power;
        }

        public int getToughness() {
            return this.toughness;
        }

        public String getRule() {
            StringBuilder sb = new StringBuilder("<b>LEVEL ");
            sb.append(this.level1);
            if (this.level2 == -1) {
                sb.append('+');
            } else {
                sb.append('-');
                sb.append(this.level2);
            }
            sb.append("</b><br>");
            sb.append(this.power);
            sb.append('/');
            sb.append(this.toughness);
            List<String> abilityText = this.abilities.getRules();
            if (!abilityText.isEmpty()) {
                sb.append("<br>");
                sb.append(abilityText.stream().collect(Collectors.joining("<br>")));
            }
            return sb.toString();
        }
    }
}

