/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.ApprovingObject;
import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.costs.common.PayLifeCost;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.costs.mana.ManaCosts;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.SpellAbilityCastMode;
import mage.constants.SpellAbilityType;
import mage.game.Game;
import mage.players.Player;

class MadnessCastEffect
extends OneShotEffect {
    private final ManaCosts<ManaCost> madnessCost;
    private final int lifeCost;

    public MadnessCastEffect(ManaCosts<ManaCost> madnessCost, int lifeCost) {
        super(Outcome.Benefit);
        this.madnessCost = madnessCost;
        this.lifeCost = lifeCost;
        String costText = lifeCost > 0 ? madnessCost.getText() + " and " + lifeCost + " life" : madnessCost.getText();
        this.staticText = "you may cast it by paying " + costText + " instead of putting it into your graveyard";
    }

    private MadnessCastEffect(MadnessCastEffect effect) {
        super(effect);
        this.madnessCost = effect.madnessCost;
        this.lifeCost = effect.lifeCost;
    }

    @Override
    public MadnessCastEffect copy() {
        return new MadnessCastEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Card card = game.getCard(source.getSourceId());
        if (card == null) {
            return false;
        }
        Player owner = game.getPlayer(card.getOwnerId());
        if (owner == null) {
            return false;
        }
        SpellAbility castByMadness = card.getSpellAbility().copy();
        ManaCosts<ManaCost> costRef = castByMadness.getManaCostsToPay();
        castByMadness.setSpellAbilityType(SpellAbilityType.BASE_ALTERNATE);
        castByMadness.setSpellAbilityCastMode(SpellAbilityCastMode.MADNESS);
        castByMadness.clearCosts();
        castByMadness.addCost(new PayLifeCost(this.lifeCost));
        costRef.clear();
        costRef.add(this.madnessCost);
        return owner.cast(castByMadness, game, false, new ApprovingObject(source, game));
    }
}

