/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.Ability;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class MentorEffect
extends AddCountersTargetEffect {
    MentorEffect() {
        super(CounterType.P1P1.createInstance(), Outcome.BoostCreature);
    }

    private MentorEffect(MentorEffect effect) {
        super(effect);
    }

    @Override
    public MentorEffect copy() {
        return new MentorEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        if (!super.apply(game, source)) {
            return false;
        }
        Permanent mentoredPermanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (mentoredPermanent == null) {
            return false;
        }
        game.fireEvent(GameEvent.getEvent(GameEvent.EventType.MENTORED_CREATURE, mentoredPermanent.getId(), source, source.getControllerId()));
        return true;
    }
}

