/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.ApprovingObject;
import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.costs.mana.ManaCosts;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class MiracleEffect
extends OneShotEffect {
    private final ManaCosts<ManaCost> miracleCosts;

    public MiracleEffect(String miracleCosts) {
        super(Outcome.Benefit);
        this.staticText = "cast this card for its miracle cost";
        this.miracleCosts = new ManaCostsImpl<ManaCost>(miracleCosts);
    }

    protected MiracleEffect(MiracleEffect effect) {
        super(effect);
        this.miracleCosts = effect.miracleCosts;
    }

    @Override
    public MiracleEffect copy() {
        return new MiracleEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (controller != null && card != null) {
            SpellAbility abilityToCast = card.getSpellAbility().copy();
            ManaCosts<ManaCost> costRef = abilityToCast.getManaCostsToPay();
            costRef.clear();
            costRef.add(this.miracleCosts);
            controller.cast(abilityToCast, game, false, new ApprovingObject(source, game));
            return true;
        }
        return false;
    }
}

